{include file="documentHeader"}
<head>
	<title>{lang}wcf.user.profile.title{/lang} - {lang}wcf.user.profile.members{/lang} - {lang}{PAGE_TITLE}{/lang}</title>
	{include file='headInclude' sandbox=false}
	<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/MultiPagesLinks.class.js"></script>
</head>
<body{if $templateName|isset} id="tpl{$templateName|ucfirst}"{/if}>
{* --- quick search controls --- *}
{assign var='searchFieldTitle' value='{lang}wcf.user.profile.search.query{/lang}'}
{capture assign=searchHiddenFields}
	<input type="hidden" name="userID" value="{@$user->userID}" />
{/capture}
{* --- end --- *}
{include file='header' sandbox=false}

<div id="main">
	{include file="userProfileHeader"}
	
	<div class="border {if $this|method_exists:'getUserProfileMenu' && $this->getUserProfileMenu()->getMenuItems('')|count > 1}tabMenuContent{else}content{/if}">
		<div class="container-1">
			{if $albums|count > 0}
				
				<div class="contentBox">
					<h3 class="subHeadline">{lang}wcf.user.gallery.albums{/lang} <span>({#$items})</span></h3>
					
					<div class="contentHeader"> </div>
					<ul class="galleryIndex floatContainer">
						{foreach from=$albums item=album}
							<li class="floatedElement container-4 deletable">
								<a href="index.php?page=UserGalleryPhotos&amp;albumID={@$album->albumID}{@SID_ARG_2ND}#profileContent" title="{$album->title}">
									<span class="thumbnail" style="width: {@$album->getCoverPhoto()->getTinyWidth()}px;"><img src="{$album->getCoverPhoto()->getPhoto('tiny')}" alt="" /></span>
									<span class="caption">{$album->title}</span>
								</a>
								<p class="smallFont light">{lang}wcf.user.gallery.album.numberOfPhotos{/lang}</p>
								{if $album->isDeletable() || $album->isEditable() || $additionalAlbumButtons[$album->albumID]|isset}
									<div class="thumbnailButtons">
										{if $album->isDeletable()}<a href="index.php?action=UserGalleryAlbumDelete&amp;albumID={@$album->albumID}&amp;t={@SECURITY_TOKEN}{@SID_ARG_2ND}" title="{lang}wcf.user.gallery.album.delete{/lang}" class="deleteButton"><img src="{icon}deleteS.png{/icon}" alt="" longdesc="{lang}wcf.user.gallery.album.delete.sure{/lang}" /></a>{/if}
										{if $album->isEditable()}<a href="index.php?form=UserGalleryAlbumEdit&amp;albumID={@$album->albumID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.album.edit{/lang}"><img src="{icon}editS.png{/icon}" alt="" /></a>{/if}
										{if $additionalAlbumButtons[$album->albumID]|isset}{@$additionalAlbumButtons[$album->albumID]}{/if}
									</div>
								{/if}
							</li>
						{/foreach}
					</ul>
					<div class="contentFooter">
						{if $this->user->userID == $user->userID && $this->user->getPermission('user.gallery.canUseGallery')}
							{pages print=true assign=pagesOutput link="index.php?page=UserGalleryAlbumList&userID=$userID&pageNo=%d"|concat:SID_ARG_2ND_NOT_ENCODED}
			
							<div class="largeButtons">
								<ul>
									<li><a href="index.php?form=UserGalleryAlbumAdd{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.album.add{/lang}"><img src="{icon}galleryAlbumAddM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.album.add{/lang}</span></a></li>
									
									{if $additionalLargeButtons|isset}{@$additionalLargeButtons}{/if}
								</ul>
							</div>
						{/if}
					</div>
				</div>
			{elseif $this->user->userID == $user->userID && $this->user->getPermission('user.gallery.canUseGallery')}
				<div class="contentBox">
					<h3 class="subHeadline">{lang}wcf.user.gallery.albums{/lang} <span>(0)</span></h3>
					
					<p>{lang}wcf.user.gallery.album.noAlbums{/lang}</p>
					<div class="largeButtons">
						<ul>
							<li><a href="index.php?form=UserGalleryAlbumAdd{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.album.add{/lang}"><img src="{icon}galleryAlbumAddM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.album.add{/lang}</span></a></li>
							
							{if $additionalLargeButtons|isset}{@$additionalLargeButtons}{/if}
						</ul>
					</div>
				</div>
			{/if}
		</div>
	</div>

</div>

{include file='footer' sandbox=false}
</body>
</html>