DROP TABLE IF EXISTS wcf1_user_gallery;
CREATE TABLE wcf1_user_gallery (
	photoID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	ownerID INT(10) NOT NULL,
	albumID INT(10) NOT NULL DEFAULT 0,
	title VARCHAR(255) NOT NULL DEFAULT '',
	description TEXT NULL,
	filename VARCHAR(255) NOT NULL DEFAULT '',
	fileExtension VARCHAR(7) NOT NULL DEFAULT '',
	photoHash VARCHAR(8) NOT NULL DEFAULT '',
	filesize INT(10) NOT NULL DEFAULT 0,
	usedQuota INT(10) NOT NULL DEFAULT 0,
	comments SMALLINT(5) NOT NULL DEFAULT 0,
	uploadTime INT(10) NOT NULL DEFAULT 0,
	creationTime INT(10) NOT NULL DEFAULT 0,
	width SMALLINT(5) NOT NULL DEFAULT 0,
	height SMALLINT(5) NOT NULL DEFAULT 0,
	camera VARCHAR(255) NOT NULL DEFAULT '',
	views MEDIUMINT(8) NOT NULL DEFAULT 0,
	latitude float(10,7) NOT NULL DEFAULT 0,
	longitude float(10,7) NOT NULL DEFAULT 0,
	hasQuadraticThumbnail TINYINT(1) NOT NULL DEFAULT 0,
	hasTinyThumbnail TINYINT(1) NOT NULL DEFAULT 0,
	hasSmallThumbnail TINYINT(1) NOT NULL DEFAULT 0,
	hasMediumThumbnail TINYINT(1) NOT NULL DEFAULT 0,
	hasLargeThumbnail TINYINT(1) NOT NULL DEFAULT 0,
	KEY (ownerID),
	KEY (albumID)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS wcf1_user_gallery_comment;
CREATE TABLE wcf1_user_gallery_comment (
	commentID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	ownerID INT(10) NOT NULL,
	photoID INT(10) NOT NULL,
	userID INT(10) NOT NULL DEFAULT 0,
	username VARCHAR(255) NOT NULL DEFAULT '',
	comment TEXT NULL,
	time INT(10) NOT NULL DEFAULT 0,
	KEY (photoID)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS wcf1_user_gallery_album;
CREATE TABLE wcf1_user_gallery_album (
	albumID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	ownerID INT(10) NOT NULL,
	title VARCHAR(255) NOT NULL DEFAULT '',
	description TEXT NULL,
	photos SMALLINT(5) NOT NULL DEFAULT 0,
	lastUpdateTime INT(10) NOT NULL DEFAULT 0,
	coverPhotoID INT(10) NOT NULL DEFAULT 0,
	KEY (ownerID)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;