<?php
// wcf imports
require_once(WCF_DIR.'lib/action/AbstractSecureAction.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbumEditor.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhoto.class.php');

/**
 * Sets the cover of a gallery album.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	action
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbumCoverSetAction extends AbstractSecureAction {
	/**
	 * album id
	 *
	 * @var integer
	 */
	public $albumID = 0;
	
	/**
	 * album editor object
	 *
	 * @var UserGalleryAlbumEditor
	 */
	public $album = null;
	
	/**
	 * photo id
	 *
	 * @var integer
	 */
	public $photoID = 0;
	
	/**
	 * photo object
	 *
	 * @var UserGalleryPhoto
	 */
	public $photo = null;
	
	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['albumID'])) $this->albumID = intval($_REQUEST['albumID']);
		$this->album = new UserGalleryAlbumEditor($this->albumID);
		if (!$this->album->albumID || !$this->album->isEditable()) {
			throw new IllegalLinkException();
		}
		if (isset($_REQUEST['photoID'])) $this->photoID = intval($_REQUEST['photoID']);
		$this->photo = new UserGalleryPhoto($this->photoID);
		if (!$this->photo->photoID || $this->photo->albumID != $this->albumID) {
			throw new IllegalLinkException();
		}
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		
		// set cover
		$this->album->update($this->album->title, $this->album->description, $this->photoID);
		$this->executed();
		
		// forward
		HeaderUtil::redirect('index.php?page=UserGalleryPhotos&albumID='.$this->albumID.SID_ARG_2ND_NOT_ENCODED.'#profileContent');
		exit;
	}
}
?>