<?php
// wcf imports
require_once(WCF_DIR.'lib/data/tag/AbstractTaggableObject.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/TaggedUserGalleryPhoto.class.php');

/**
 * An implementation of Taggable to support the tagging of gallery photos.
 *
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery
 * @category 	Community Framework (commercial)
 */
class TaggableUserGalleryPhoto extends AbstractTaggableObject {
	/**
	 * @see Taggable::getObjectsByIDs()
	 */
	public function getObjectsByIDs($objectIDs, $taggedObjects) {
		$sql = "SELECT		*
			FROM		wcf".WCF_N."_user_gallery
			WHERE		photoID IN (" . implode(",", $objectIDs) . ")";
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray($result)) {
			$row['taggable'] = $this;
			$taggedObjects[] = new TaggedUserGalleryPhoto(null, $row);
		}
		return $taggedObjects;
	}
	
	/**
	 * @see Taggable::countObjectsByTagID()
	 */
	public function countObjectsByTagID($tagID) {
		if (!WCF::getUser()->getPermission('user.gallery.canViewGallery')) {
			return 0;
		}
		
		$sql = "SELECT	COUNT(*) AS count
			FROM	wcf".WCF_N."_tag_to_object
			WHERE	tagID = ".$tagID."
				AND taggableID = ".$this->getTaggableID();
		$row = WCF::getDB()->getFirstRow($sql);
		return $row['count'];
	}
	
	/**
	 * @see Taggable::getObjectsByTagID()
	 */
	public function getObjectsByTagID($tagID, $limit = 0, $offset = 0) {
		if (!WCF::getUser()->getPermission('user.gallery.canViewGallery')) {
			return array();
		}
		
		$photos = array();
		$sql = "SELECT		user_gallery.*,	user_table.username
			FROM		wcf".WCF_N."_tag_to_object tag_to_object
			LEFT JOIN	wcf".WCF_N."_user_gallery user_gallery
			ON		(user_gallery.photoID = tag_to_object.objectID)
			LEFT JOIN	wcf".WCF_N."_user user_table
			ON		(user_table.userID = user_gallery.ownerID)
			WHERE		tag_to_object.tagID = ".$tagID."
					AND tag_to_object.taggableID = ".$this->getTaggableID()."
			ORDER BY	user_gallery.uploadTime DESC";
		$result = WCF::getDB()->sendQuery($sql, $limit, $offset);
		while ($row = WCF::getDB()->fetchArray($result)) {
			$row['taggable'] = $this;
			$photos[] = new TaggedUserGalleryPhoto(null, $row);
		}
		return $photos;
	}

	/**
	 * @see Taggable::getIDFieldName()
	 */
	public function getIDFieldName() {
		return 'photoID';
	}
	
	/**
	 * @see Taggable::getResultTemplateName()
	 */
	public function getResultTemplateName() {
		return 'taggedUserGalleryPhotos';
	}
	
	/**
	 * @see Taggable::getSmallSymbol()
	 */
	public function getSmallSymbol() {
		return StyleManager::getStyle()->getIconPath('galleryS.png');
	}

	/**
	 * @see Taggable::getMediumSymbol()
	 */
	public function getMediumSymbol() {
		return StyleManager::getStyle()->getIconPath('galleryM.png');
	}
	
	/**
	 * @see Taggable::getLargeSymbol()
	 */
	public function getLargeSymbol() {
		return StyleManager::getStyle()->getIconPath('galleryL.png');
	}
}
?>