<?php
// wcf imports
require_once(WCF_DIR.'lib/data/user/infraction/warning/object/WarningObjectType.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoWarningObject.class.php');

/**
 * An implementation of WarningObjectType to support the usage of a photo as a warning object.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoWarningObjectType implements WarningObjectType {
	/**
	 * @see WarningObjectType::getObjectByID()
	 */
	public function getObjectByID($objectID) {
		if (is_array($objectID)) {
			$photos = array();
			$sql = "SELECT		*
				FROM 		wcf".WCF_N."_user_gallery
				WHERE 		photoID IN (".implode(',', $objectID).")";
			$result = WCF::getDB()->sendQuery($sql);
			while ($row = WCF::getDB()->fetchArray($result)) {
				$photos[$row['photoID']] = new UserGalleryPhotoWarningObject(null, $row);
			}
			
			return (count($photos) > 0 ? $photos : null); 
		}
		else {
			// get object
			$photo = new UserGalleryPhotoWarningObject($objectID);
			if (!$photo->photoID) return null;
			
			// return object
			return $photo;
		}
	}
}
?>