<?php
// wcf imports
require_once(WCF_DIR.'lib/data/DatabaseObject.class.php');

/**
 * Represents a gallery photo comment.
 *
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery.comment
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoComment extends DatabaseObject {
	/**
	 * Creates a new UserGalleryPhotoComment object.
	 *
	 * @param	integer		$commentID
	 * @param 	array<mixed>	$row
	 */
	public function __construct($commentID, $row = null) {
		if ($commentID !== null) {
			$sql = "SELECT	*
				FROM 	wcf".WCF_N."_user_gallery_comment
				WHERE 	commentID = ".$commentID;
			$row = WCF::getDB()->getFirstRow($sql);
		}
		parent::__construct($row);
	}
	
	/**
	 * Returns true, if the active user can edit this comment.
	 * 
	 * @return	boolean
	 */
	public function isEditable() {
		if (($this->ownerID == WCF::getUser()->userID && WCF::getUser()->getPermission('user.gallery.canEditComment')) || ($this->userID && $this->userID == WCF::getUser()->userID && WCF::getUser()->getPermission('user.gallery.canEditOwnComment')) || WCF::getUser()->getPermission('mod.gallery.canEditComment')) {
			return true;
		}
		return false;
	}
	
	/**
	 * Returns true, if the active user can delete this comment.
	 * 
	 * @return	boolean
	 */
	public function isDeletable() {
		if (($this->ownerID == WCF::getUser()->userID && WCF::getUser()->getPermission('user.gallery.canDeleteComment')) || ($this->userID && $this->userID == WCF::getUser()->userID && WCF::getUser()->getPermission('user.gallery.canDeleteOwnComment')) || WCF::getUser()->getPermission('mod.gallery.canDeleteComment')) {
			return true;
		}
		return false;
	}
	
	/**
	 * Returns an editor object for this comment.
	 *
	 * @return	UserGalleryPhotoCommentEditor
	 */
	public function getEditor() {
		require_once(WCF_DIR.'lib/data/user/gallery/comment/UserGalleryPhotoCommentEditor.class.php');
		return new UserGalleryPhotoCommentEditor(null, $this->data);
	}
}
?>