<?php
// wcf imports
require_once(WCF_DIR.'lib/data/user/gallery/comment/UserGalleryPhotoComment.class.php');

/**
 * Provides functions to manage photo comments.
 *
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery.comment
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoCommentEditor extends UserGalleryPhotoComment {
	/**
	 * Creates a new photo comment.
	 *
	 * @param	integer		$photoID
	 * @param	integer		$ownerID
	 * @param	string		$comment
	 * @param	integer		$userID
	 * @param	string		$username
	 * @param	integer		$time
	 * @return	UserGalleryPhotoCommentEditor
	 */
	public static function create($photoID, $ownerID, $comment, $userID, $username, $time = TIME_NOW) {
		$sql = "INSERT INTO	wcf".WCF_N."_user_gallery_comment
					(photoID, ownerID, userID, username, comment, time)
			VALUES		(".$photoID.", ".$ownerID.", ".$userID.", '".escapeString($username)."', '".escapeString($comment)."', ".$time.")";
		WCF::getDB()->sendQuery($sql);
		
		// get id
		$commentID = WCF::getDB()->getInsertID("wcf".WCF_N."_user_gallery_comment", 'commentID');
		
		// update photo
		$sql = "UPDATE	wcf".WCF_N."_user_gallery
			SET	comments = comments + 1
			WHERE	photoID = ".$photoID;
		WCF::getDB()->sendQuery($sql);
		
		return new UserGalleryPhotoCommentEditor($commentID);
	}
	
	/**
	 * Updates this photo comment.
	 *
	 * @param	string		$comment
	 */
	public function update($comment) {
		$sql = "UPDATE	wcf".WCF_N."_user_gallery_comment
			SET	comment = '".escapeString($comment)."'
			WHERE	commentID = ".$this->commentID;
		WCF::getDB()->sendQuery($sql);
	}
	
	/**
	 * Deletes this photo comment.
	 */
	public function delete() {
		// update photo
		$sql = "UPDATE	wcf".WCF_N."_user_gallery
			SET	comments = comments - 1
			WHERE	photoID = ".$this->photoID;
		WCF::getDB()->sendQuery($sql);
		
		// delete comment
		$sql = "DELETE FROM	wcf".WCF_N."_user_gallery_comment
			WHERE		commentID = ".$this->commentID;
		WCF::getDB()->sendQuery($sql);
	}
}
?>