<?php
// wcf imports
require_once(WCF_DIR.'lib/form/CaptchaForm.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhoto.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/comment/UserGalleryPhotoCommentEditor.class.php');

/**
 * Shows the form for adding gallery photo comments.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	form
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoCommentAddForm extends CaptchaForm {
	// parameters
	public $comment = '';
	public $username = '';
	
	/**
	 * photo editor
	 *
	 * @var UserGalleryPhoto
	 */
	public $photo = null;
	
	/**
	 * Creates a new UserGalleryPhotoCommentAddForm object.
	 *
	 * @param	UserGalleryPhoto	$photo
	 */
	public function __construct(UserGalleryPhoto $photo) {
		$this->photo = $photo;
		parent::__construct();
	}
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get photo
		if (!$this->photo->isCommentable()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		// get parameters
		if (isset($_POST['comment'])) $this->comment = StringUtil::trim($_POST['comment']);
		if (isset($_POST['username'])) $this->username = StringUtil::trim($_POST['username']);
	}
	
	/**
	 * @see Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if (empty($this->comment)) {
			throw new UserInputException('comment');
		}
		
		if (StringUtil::length($this->comment) > WCF::getUser()->getPermission('user.gallery.maxCommentLength')) {
			throw new UserInputException('comment', 'tooLong');
		}
		
		// username
		$this->validateUsername();
	}
	
	/**
	 * Validates the username.
	 */
	protected function validateUsername() {
		// only for guests
		if (WCF::getUser()->userID == 0) {
			// username
			if (empty($this->username)) {
				throw new UserInputException('username');
			}
			if (!UserUtil::isValidUsername($this->username)) {
				throw new UserInputException('username', 'notValid');
			}
			if (!UserUtil::isAvailableUsername($this->username)) {
				throw new UserInputException('username', 'notAvailable');
			}
			
			WCF::getSession()->setUsername($this->username);
		}
		else {
			$this->username = WCF::getUser()->username;
		}
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
		
		// save comment
		$comment = UserGalleryPhotoCommentEditor::create($this->photo->photoID, $this->photo->ownerID, $this->comment, WCF::getUser()->userID, $this->username);
		$this->saved();
		
		// forward
		HeaderUtil::redirect('index.php?page=UserGalleryPhoto&photoID='.$this->photo->photoID.'&commentID='.$comment->commentID.SID_ARG_2ND_NOT_ENCODED.'#comment'.$comment->commentID);
		exit;
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'comment' => $this->comment,
			'username' => $this->username,
			'maxTextLength' => WCF::getUser()->getPermission('user.gallery.maxCommentLength')
		));
	}
}
?>