<?php
// wcf imports
require_once(WCF_DIR.'lib/form/UserGalleryPhotoCommentAddForm.class.php');

/**
 * Shows the form for editing gallery photo comments.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	form
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoCommentEditForm extends UserGalleryPhotoCommentAddForm {
	/**
	 * comment editor
	 *
	 * @var UserGalleryPhotoCommentEditor
	 */
	public $commentObj = null;
	
	/**
	 * Creates a new UserGalleryPhotoCommentEditForm object.
	 *
	 * @param	UserGalleryPhotoComment		$comment
	 */
	public function __construct(UserGalleryPhotoComment $comment) {
		$this->commentObj = $comment->getEditor();
		CaptchaForm::__construct();
	}
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		CaptchaForm::readParameters();
		
		// get comment
		if (!$this->commentObj->isEditable()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		CaptchaForm::save();
		
		// save comment
		$this->commentObj->update($this->comment);
		$this->saved();
		
		// forward
		HeaderUtil::redirect('index.php?page=UserGalleryPhoto&photoID='.$this->commentObj->photoID.'&commentID='.$this->commentObj->commentID.SID_ARG_2ND_NOT_ENCODED.'#comment'.$this->commentObj->commentID);
		exit;
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		if (!count($_POST)) {
			$this->comment = $this->commentObj->comment;
		}
	}
}
?>