<?php
// wcf imports
require_once(WCF_DIR.'lib/page/SortablePage.class.php');
require_once(WCF_DIR.'lib/page/util/menu/PageMenu.class.php');

/**
 * Shows an overview of all user galleries.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	page
 * @category 	Community Framework (commercial)
 */
class UserGalleryOverviewPage extends SortablePage {
	// system
	public $templateName = 'userGalleryOverview';
	public $defaultSortField = 'uploadTime';
	public $defaultSortOrder = 'DESC';
	public $itemsPerPage = 30;
	
	/**
	 * list of gallery photos
	 *
	 * @var UserGalleryPhotoList
	 */
	public $photoList = null;
	
	/**
	 * list of all photos
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $allPhotos = array();
	
	/**
	 * tag list object
	 *
	 * @var TagList
	 */
	public $tagList = null;
	
	/**
	 * list of tags
	 * 
	 * @var	array
	 */
	public $tags = array();
	
	/**
	 * tag id
	 *
	 * @var integer
	 */
	public $tagID = 0;
	
	/**
	 * tag object
	 *
	 * @var Tag
	 */
	public $tag = null;
	
	/**
	 * taggable object
	 *
	 * @var Taggable
	 */
	public $taggable = null;
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get tag
		if (isset($_REQUEST['tagID'])) $this->tagID = intval($_REQUEST['tagID']);
		
		// init photo list
		if (MODULE_TAGGING && $this->tagID) {
			require_once(WCF_DIR.'lib/data/tag/TagEngine.class.php');
			$this->tag = TagEngine::getInstance()->getTagByID($this->tagID);
			if ($this->tag === null) {
				throw new IllegalLinkException();
			}
			require_once(WCF_DIR.'lib/data/user/gallery/TaggedUserGalleryPhotoOverviewList.class.php');
			$this->photoList = new TaggedUserGalleryPhotoOverviewList($this->tagID);
		}
		else {
			require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoOverviewList.class.php');
			$this->photoList = new UserGalleryPhotoOverviewList();
		}
		
		// init tag list
		if (MODULE_TAGGING) {
			require_once(WCF_DIR.'lib/data/tag/TagList.class.php');
			$this->tagList = new TagList(array('com.woltlab.wcf.user.gallery.photo'), WCF::getSession()->getVisibleLanguageIDArray());
		}
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		// read all
		$this->photoList->sqlLimit = 100;
		$this->photoList->sqlOrderBy = 'user_gallery.'.$this->sortField.' '.$this->sortOrder;
		$this->photoList->readObjects();
		$this->allPhotos = $this->photoList->getObjects();
		$this->photoList->photos = array();
		
		// read photos
		$this->photoList->sqlLimit = $this->itemsPerPage;
		$this->photoList->sqlOffset = ($this->pageNo - 1) * $this->itemsPerPage;
		$this->photoList->readObjects();

		// read tags
		if (MODULE_TAGGING) {
			$this->tagList->readObjects();
			$this->tags = $this->tagList->getObjects();
		}
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();
		
		return $this->photoList->countObjects();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'allPhotos' => $this->allPhotos,
			'photos' => $this->photoList->getObjects(),
			'tagID' => $this->tagID,
			'tag' => $this->tag,
			'tags' => $this->tags,
			'taggableID' => ($this->taggable !== null ? $this->taggable->getTaggableID() : 0),
			'allowSpidersToIndexThisPage' => true
		));
	}
	
	/**
	 * @see SortablePage::validateSortField()
	 */
	public function validateSortField() {
		parent::validateSortField();
		
		switch ($this->sortField) {
			case 'title':
			case 'filename':
			case 'fileExtension':
			case 'comments':
			case 'uploadTime': break;
			default: $this->sortField = $this->defaultSortField;
		}
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active header menu item
		PageMenu::setActiveMenuItem('wcf.header.menu.user.gallery');
		
		// check permission
		WCF::getUser()->checkPermission('user.gallery.canViewGallery');
		
		if (!MODULE_USER_GALLERY) {
			throw new IllegalLinkException();
		}
		
		parent::show();
	}
}
?>